<?php
// ============================================================
// IMPRESSÃO EM MASSA DE RECIBOS (MÁXIMO 6 POR FOLHA)
// Otimizado para impressão no modo Retrato (Portrait), 3x2.
// ============================================================
session_start();
// Assume que 'conexao.php' está acessível e contém as credenciais de conexão
// O código para a conexão foi inserido diretamente aqui para fins de demonstração
$host = "localhost";
$user = "root";
$pass = "";
$db = "sismag";
$port = 3307; 

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// Verifique se o usuário está logado
if (!isset($_SESSION['usuario'])) {
    die("Acesso não autorizado.");
}

// Verifica se os IDs foram passados e são válidos
if (!isset($_GET['ids']) || !is_array($_GET['ids']) || count($_GET['ids']) === 0) {
    die("Nenhum pagamento selecionado para impressão.");
}

$ids_pagamento = array_map('intval', $_GET['ids']);
$ids_pagamento = array_filter($ids_pagamento); // Remove IDs inválidos (0)

// NOVO LIMITE: Máximo de 6 recibos
if (count($ids_pagamento) > 6) {
    die("Limite de 6 recibos por impressão em massa excedido.");
}

// Cria a lista de placeholders '?' para a query IN
$placeholders = implode(',', array_fill(0, count($ids_pagamento), '?'));
$tipos = str_repeat('i', count($ids_pagamento));

// Consulta para buscar todos os dados dos pagamentos selecionados
$sql = "SELECT 
            p.id AS id_pagamento, 
            p.mes_pagamento, 
            p.valor_pago, /* CORRIGIDO: Usando 'valor_pago' conforme estrutura da tabela propinas */
            p.data_pagamento,
            p.status,
            a.nome AS nome_aluno, 
            t.nome AS nome_turma,
            t.curso AS curso_turma,
            t.classe AS classe_turma,
            t.sala AS sala_turma /* Campo Sala adicionado */
        FROM 
            propinas p
        JOIN 
            alunos a ON p.aluno_id = a.id
        LEFT JOIN
            turmas t ON a.turma_id = t.id
        WHERE 
            p.id IN ($placeholders)
        ORDER BY p.data_pagamento DESC";

$stmt = $conn->prepare($sql);

// Bind dos parâmetros
$stmt->bind_param($tipos, ...$ids_pagamento);
$stmt->execute();
$result = $stmt->get_result();

$recibos = [];
if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $recibos[] = $row;
    }
} else {
    // Isso deve ser raro devido à verificação inicial, mas é uma boa prática
    die("Nenhum pagamento encontrado para os IDs selecionados.");
}

$stmt->close();
$conn->close();

?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Impressão em Massa de Recibos</title>
    <style>
        /* Estilos específicos para impressão em massa */
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 10px;
            background: #f8f9fa;
            color: #222;
        }

        /* Oculta botões e navegação na impressão e ajusta para 6 por página (3x2) */
        @media print {
            .no-print { display: none; }
            /* Orientação Retrato e margem ajustada */
            @page { size: A4 portrait; margin: 8mm; /* Margem ligeiramente reduzida */ }
            body { background: white; }
            
            /* Garante que os contêineres não sejam cortados */
            .recibo-container {
                page-break-inside: avoid;
            }
        }

        .no-print {
            text-align: center;
            margin-bottom: 20px;
        }

        .no-print button, .no-print a {
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            text-decoration: none;
            font-size: 15px;
            margin: 0 5px;
            cursor: pointer;
        }

        .no-print button { background-color: #28a745; color: white; }
        .no-print a { background-color: #007bff; color: white; }

        /* Contêiner para 2 colunas */
        .recibo-container {
            width: 48%; /* 2 colunas */
            margin: 1%;
            display: inline-block;
            vertical-align: top;
            box-sizing: border-box;
        }

        .recibo {
            border: 1px solid #003366;
            border-radius: 4px;
            background: white;
            padding: 12px 15px; /* Reduzido padding interno */
            /* Altura ajustada para caber 3 por coluna em A4 Retrato */
            height: 290px; 
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            box-shadow: 0 0 4px rgba(0,0,0,0.15);
        }

        /* NOVO ESTILO PARA O LOGO */
        .logo-recibo {
            display: block;
            width: 40px; /* Tamanho reduzido para caber no layout 3x2 */
            height: auto;
            margin: 0 auto 5px; /* Centraliza e adiciona margem inferior */
        }

        .cabecalho-escola {
            text-align: center;
            font-size: 11px;
            font-weight: bold;
            color: #003366;
            margin-bottom: 4px;
        }

        h4 {
            text-align: center;
            color: #003366;
            margin: 4px 0 8px; /* Reduzido margin bottom */
            font-size: 13px;
            border-bottom: 1px dashed #ccc;
            padding-bottom: 3px;
        }

        .linha {
            margin-bottom: 4px; /* Reduzido espaçamento entre linhas */
            font-size: 12px;
        }

        .linha strong {
            color: #003366;
            font-weight: bold;
            /* Ajuda a alinhar o valor com o rótulo */
            width: 80px; 
            display: inline-block;
        }

        .valor {
            font-size: 13px;
            font-weight: bold;
            color: #dc3545; /* Destaca o valor */
        }

        .rodape-recibo {
            border-top: 1px dashed #ccc;
            margin-top: auto; /* Empurra para baixo */
            padding-top: 5px; /* Reduzido padding superior */
        }

        .assinatura {
            margin-top: 10px; /* Reduzido espaçamento */
            text-align: center;
        }

        .assinatura p {
            display: inline-block;
            border-top: 1px solid #333;
            width: 60%;
            font-size: 11px;
            margin: 0;
            padding-top: 4px;
        }
    </style>
</head>
<body>

<div class="no-print">
    <button onclick="window.print()">🖨️ Iniciar Impressão</button>
    <a href="historico_pagamentos.php">⬅ Voltar</a>
</div>

<?php foreach ($recibos as $dados): ?>
<div class="recibo-container">
    <div class="recibo">
        <div>
            <!-- LOGOTIPO ADICIONADO AQUI -->
            <img src="logo/logo.jpg" alt="Logotipo da Escola" class="logo-recibo">
            
            <div class="cabecalho-escola">COMPLEXO ESCOLAR BG 0026 PADRE EMIL FRICK</div>
            <h4>Recibo de Propina Nº <?= htmlspecialchars($dados['id_pagamento']) ?></h4>

            <div class="linha"><strong>Aluno:</strong> <?= htmlspecialchars($dados['nome_aluno']) ?></div>
            <div class="linha"><strong>Turma:</strong> <?= htmlspecialchars($dados['nome_turma'] ?? '-') ?></div>
            <div class="linha"><strong>Classe:</strong> <?= htmlspecialchars($dados['classe_turma'] ?? '-') ?></div>
            <div class="linha"><strong>Sala:</strong> <?= htmlspecialchars($dados['sala_turma'] ?? '-') ?></div>
            <div class="linha"><strong>Mês:</strong> <?= htmlspecialchars($dados['mes_pagamento'] ?? '-') ?></div>
        </div>

        <div class="rodape-recibo">
            <div class="linha"><strong>Status:</strong> <span style="color:green;"><?= htmlspecialchars($dados['status']) ?></span></div>
            <div class="linha"><strong>Valor:</strong> <span class="valor"><?= number_format($dados['valor_pago'], 2, ',', '.') ?> Kz</span></div>
            <div class="linha"><strong>Data:</strong> <?= date("d/m/Y", strtotime($dados['data_pagamento'])) ?></div>

            <div class="assinatura">
                <p>Secretaria</p>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>

</body>
</html>
